/*
 * Decompiled with CFR 0.152.
 */
package com.github.monun.survival.tap.event;

import com.github.monun.survival.tap.event.EventEntity;
import com.github.monun.survival.tap.event.HandlerStatement;
import com.github.monun.survival.tap.event.ListenerStatement;
import com.github.monun.survival.tap.event.RegisteredEntityHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lcom/github/monun/survival/tap/event/RegisteredEntityListener;", "", "eventEntity", "Lcom/github/monun/survival/tap/event/EventEntity;", "statement", "Lcom/github/monun/survival/tap/event/ListenerStatement;", "listener", "Lorg/bukkit/event/Listener;", "(Lcom/github/monun/tap/event/EventEntity;Lcom/github/monun/tap/event/ListenerStatement;Lorg/bukkit/event/Listener;)V", "handlers", "Lcom/google/common/collect/ImmutableList;", "Lcom/github/monun/survival/tap/event/RegisteredEntityHandler;", "getHandlers", "()Lcom/google/common/collect/ImmutableList;", "getListener", "()Lorg/bukkit/event/Listener;", "getStatement", "()Lcom/github/monun/tap/event/ListenerStatement;", "unregister", "", "api"})
public final class RegisteredEntityListener {
    @NotNull
    private final ImmutableList<RegisteredEntityHandler> handlers;
    private final EventEntity eventEntity;
    @NotNull
    private final ListenerStatement statement;
    @NotNull
    private final Listener listener;

    @NotNull
    public final ImmutableList<RegisteredEntityHandler> getHandlers() {
        return this.handlers;
    }

    public final void unregister() {
        this.eventEntity.unregister(this);
    }

    @NotNull
    public final ListenerStatement getStatement() {
        return this.statement;
    }

    @NotNull
    public final Listener getListener() {
        return this.listener;
    }

    public RegisteredEntityListener(@NotNull EventEntity eventEntity2, @NotNull ListenerStatement statement, @NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)eventEntity2, (String)"eventEntity");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.eventEntity = eventEntity2;
        this.statement = statement;
        this.listener = listener2;
        ImmutableList<HandlerStatement> handlerStatements = this.statement.getHandlerStatements();
        ArrayList<RegisteredEntityHandler> handlers = new ArrayList<RegisteredEntityHandler>(handlerStatements.size());
        UnmodifiableIterator unmodifiableIterator = handlerStatements.iterator();
        while (unmodifiableIterator.hasNext()) {
            HandlerStatement handlerStatement;
            HandlerStatement handlerStatement2 = handlerStatement = (HandlerStatement)unmodifiableIterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)handlerStatement2, (String)"handlerStatement");
            handlers.add(new RegisteredEntityHandler(handlerStatement2, this.listener));
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)handlers);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"ImmutableList.copyOf(handlers)");
        this.handlers = immutableList;
    }
}

